/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector.objects.blocks;

import andrews.online_detector.block_entities.OnlineDetectorBlockEntity;
import andrews.online_detector.config.ODConfigs;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OnlineDetectorBlock
extends BaseEntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"is_active");
    public static final BooleanProperty IS_INVERTED = BooleanProperty.m_61465_((String)"is_inverted");
    protected static final VoxelShape BOTTOM_PART = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape TOP_PART = Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    protected static final VoxelShape AABB = Shapes.m_83110_((VoxelShape)BOTTOM_PART, (VoxelShape)TOP_PART);
    private static final float PIXEL_SIZE = 0.0625f;

    public OnlineDetectorBlock() {
        super(OnlineDetectorBlock.getProperties());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    private static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_);
        properties.m_60913_(1.5f, 6.0f);
        properties.m_60999_();
        properties.m_60953_(OnlineDetectorBlock.getLightValueLit(7));
        return properties;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)IS_ACTIVE) != false && (Boolean)state.m_61143_((Property)IS_INVERTED) == false || (Boolean)state.m_61143_((Property)IS_ACTIVE) == false && (Boolean)state.m_61143_((Property)IS_INVERTED) != false ? lightValue : 0;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)IS_INVERTED)).booleanValue() || !((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && ((Boolean)state.m_61143_((Property)IS_INVERTED)).booleanValue()) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> 0;
                case Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> 15;
            };
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_INVERTED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)IS_INVERTED) == false)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.f_46443_ && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OnlineDetectorBlockEntity) {
                OnlineDetectorBlockEntity onlineDetectorBlockEntity = (OnlineDetectorBlockEntity)blockEntity;
                onlineDetectorBlockEntity.setOwnerUUID(player.m_142081_());
                onlineDetectorBlockEntity.setOwnerName(player.m_7755_().getString());
                onlineDetectorBlockEntity.setOwnerHead(new ItemStack((ItemLike)Items.f_41852_));
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OnlineDetectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> OnlineDetectorBlockEntity.tick(level1, pos, state1, (OnlineDetectorBlockEntity)blockEntity);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122427_())).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_INVERTED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, IS_ACTIVE, IS_INVERTED});
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if ((((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && !((Boolean)state.m_61143_((Property)IS_INVERTED)).booleanValue() || !((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && ((Boolean)state.m_61143_((Property)IS_INVERTED)).booleanValue()) && ODConfigs.ODClientConfig.shouldShowRedstoneParticles.get().booleanValue()) {
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.125f), (double)((float)pos.m_123343_() - 0.0625f), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.125f), (double)((float)pos.m_123343_() + 1.0625f), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() - 0.0625f), (double)((float)pos.m_123342_() + 0.125f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() + 1.0625f), (double)((float)pos.m_123342_() + 0.125f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 0.0625f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
        }
        if (((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && ODConfigs.ODClientConfig.shouldShowPortalParticles.get().booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                int XAxisRandom = random.nextInt(2) * 2 - 1;
                int ZAxisRandom = random.nextInt(2) * 2 - 1;
                double xPos = (double)pos.m_123341_() + 0.5 + 0.25 * (double)XAxisRandom;
                double yPos = (float)pos.m_123342_() + 0.5f + random.nextFloat();
                double zPos = (double)pos.m_123343_() + 0.5 + 0.25 * (double)ZAxisRandom;
                double xMotion = random.nextFloat() * (float)XAxisRandom;
                double yMotion = ((double)random.nextFloat() - 0.5) * 0.125;
                double zMotion = random.nextFloat() * (float)ZAxisRandom;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, xPos, yPos, zPos, xMotion, yMotion, zMotion);
            }
        }
    }
}

